/* @license GNU-GPL-2.0-or-later https://www.drupal.org/licensing/faq */
(function() {
  'use strict';
  
  // Variable para controlar si ya se inicializ܇
  let initialized = false;
  
  function initLicenciaPopup() {
    // Evitar inicializaci܇n m~ltiple
    if (initialized) return;
    initialized = true;
    
    const licenciaLinks = document.querySelectorAll('.licencia-link');
    const popup = document.getElementById('licencia-popup');
    const overlay = document.getElementById('licencia-popup-overlay');
    const popupTitulo = document.getElementById('licencia-popup-titulo');
    const popupBody = document.getElementById('licencia-popup-body');
    const closeButton = document.querySelector('.licencia-popup-close');
    
    // Funci܇n para decodificar HTML correctamente
    function decodeHtml(html) {
      const textArea = document.createElement('textarea');
      textArea.innerHTML = html;
      return textArea.value;
    }
    
    function openPopup(titulo, element) {
      if (!popup || !overlay || !popupTitulo || !popupBody) return;
      
      popupTitulo.textContent = titulo;
      
      // Obtenemos el contenido CODIFICADO del atributo
      const encodedContent = element.getAttribute('data-body');
      
      if (encodedContent) {
        // Decodificamos CORRECTAMENTE el HTML
        const fullHtml = decodeHtml(encodedContent);
        
        // Insertamos el HTML COMPLETO en el popup
        popupBody.innerHTML = fullHtml;
      }
      
      popup.style.display = 'block';
      overlay.style.display = 'block';
      document.body.style.overflow = 'hidden';
      
      // Aqu podras agregar cualquier inicializaci܇n adicional para elementos dinmicos
      initDynamicElements(popupBody);
    }
    
    function closePopup() {
      if (!popup || !overlay) return;
      
      popup.style.display = 'none';
      overlay.style.display = 'none';
      document.body.style.overflow = 'auto';
    }
    
    // Funci܇n para inicializar elementos dinmicos (reemplaza Drupal.attachBehaviors)
    function initDynamicElements(container) {
      // Aqu puedes agregar cualquier inicializaci܇n especfica para elementos
      // que se agreguen dinmicamente al popup
      
      // Ejemplo: reinicializar tooltips, acordeones, etc.
      // initTooltips(container);
      // initAccordions(container);
    }
    
    // Event listeners para los links de licencia
    licenciaLinks.forEach(function(link) {
      link.addEventListener('click', function(e) {
        e.preventDefault();
        const titulo = this.getAttribute('data-titulo') || 'Licencia';
        openPopup(titulo, this);
      });
    });
    
    // Event listener para el bot܇n de cerrar
    if (closeButton) {
      closeButton.addEventListener('click', closePopup);
    }
    
    // Event listener para cerrar al hacer click en el overlay
    if (overlay) {
      overlay.addEventListener('click', closePopup);
    }
    
    // Event listener para cerrar con la tecla Escape
    document.addEventListener('keydown', function(e) {
      if (e.key === 'Escape' && popup && popup.style.display === 'block') {
        closePopup();
      }
    });
  }
  
  // Inicializar cuando el DOM est listo
  if (document.readyState === 'loading') {
    document.addEventListener('DOMContentLoaded', initLicenciaPopup);
  } else {
    // El DOM ya est cargado
    initLicenciaPopup();
  }
  
  // Tambin inicializar si se llama despus de cargar la pgina
  window.initLicenciaPopup = initLicenciaPopup;
  
})();
/*
(function (Drupal) {
  'use strict';

  Drupal.behaviors.licenciaPopup = {
    attach: function (context, settings) {
      once('licencia-popup', 'body', context).forEach(function () {
        const licenciaLinks = document.querySelectorAll('.licencia-link');
        const popup = document.getElementById('licencia-popup');
        const overlay = document.getElementById('licencia-popup-overlay');
        const popupTitulo = document.getElementById('licencia-popup-titulo');
        const popupBody = document.getElementById('licencia-popup-body');
        const closeButton = document.querySelector('.licencia-popup-close');
        

        // Funcion para decodificar HTML correctamente
        function decodeHtml(html) {
          const textArea = document.createElement('textarea');
          textArea.innerHTML = html;
          return textArea.value;
        }

        function openPopup(titulo, element) {
          popupTitulo.textContent = titulo;
          
          // Obtenemos el contenido CODIFICADO del atributo
          const encodedContent = element.getAttribute('data-body');
          
          // Decodificamos CORRECTAMENTE el HTML
          const fullHtml = decodeHtml(encodedContent);
          
          // Insertamos el HTML COMPLETO en el popup
          popupBody.innerHTML = fullHtml;
          
          popup.style.display = 'block';
          overlay.style.display = 'block';
          document.body.style.overflow = 'hidden';
          
          // Reactivar comportamientos de Drupal para elementos dinHmicos
          Drupal.attachBehaviors(popupBody);
        }

        function closePopup() {
          popup.style.display = 'none';
          overlay.style.display = 'none';
          document.body.style.overflow = 'auto';
        }

        licenciaLinks.forEach(function (link) {
          link.addEventListener('click', function (e) {
            e.preventDefault();
            openPopup(this.getAttribute('data-titulo'), this);
          });
        });

        if (closeButton) {
          closeButton.addEventListener('click', closePopup);
        }

        if (overlay) {
          overlay.addEventListener('click', closePopup);
        }

        document.addEventListener('keydown', function (e) {
          if (e.key === 'Escape' && popup.style.display === 'block') {
            closePopup();
          }
        });
      });
    }
  };
})(Drupal);*/;
